
@extends('layouts.app')

@section('styles')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire_edit.css') }}">
@endsection

@section('content')
@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif
@if(Auth::check())
<div class="salle-sport-edit">
<div class="container">
    <form action="{{ route('jeunesse.store') }}" method="POST" enctype="multipart/form-data" lang="ar">
    @csrf
        <input type="hidden" name="id_formulaire" value="{{ $formulaire->id_type }}">
        <h2>الجمهورية التونسية</h2>
        <h2>وزارة الشباب و الرياضة</h2>
        <h4 style="text-align:center;"> الإدارة العامة للشباب </h4>

        
        <h3>{{ $formulaire->type_ar }}</h3>
        <div class="form-section">
            <h4>المستثمر</h4>
            
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">الاسم و اللقب</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" name="nom_prenom" value="{{ old('nom_prenom', Auth::user()->nom_prenom ?? '') }}" readonly>
                </div>
            </div>


            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">مكان الولادة</label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" name="lieu_naissance" value="{{ old('lieu_naissance', Auth::user()->lieu_naissance ?? '') }}" readonly>
                </div>

                <label class="col-sm-2 col-form-label">تاريخ الولادة</label>
                <div class="col-sm-4">
                    <input type="date" class="form-control" name="date_naissance"  value="{{ old('date_naissance', Auth::user()->date_naissance ?? '') }}" readonly>
                </div>
            </div>
                        
            <div class="form-group row align-items-center">
                <label class="col-sm-2 col-form-label">الهوية الشخصية</label>  
                <div class="col-sm-4">
                    <input type="text" class="form-control" 
                        value="{{ Auth::user()->typeIdentite->type_ar ?? '' }}" 
                        readonly>
                </div>

                @php $user = Auth::user(); @endphp

                @if($user->id_type_identite == 1)
                    <div class="col-sm-6">
                        <input type="text" class="form-control" value="{{ $user->cin ?? '' }}" readonly>
                    </div>
                @elseif($user->id_type_identite == 2)
                    <div class="col-sm-6">
                        <input type="text" class="form-control" value="{{ $user->passport ?? '' }}" readonly>
                    </div>
                @elseif($user->id_type_identite == 3)
                    <div class="col-sm-6">
                        <input type="text" class="form-control" value="{{ $user->num_fiscal ?? '' }}" readonly>
                    </div>
                @endif
            </div>

            @if($user->id_type_identite == 1)
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">تاريخ الإصدار</label>
                <div class="col-sm-4">
                    <input type="date" class="form-control" 
                        value="{{ $user->date_delivrance_cin ? \Carbon\Carbon::parse($user->date_delivrance_cin)->format('Y-m-d') : '' }}" 
                        readonly>
                </div>

                <label class="col-sm-2 col-form-label">مكان الإصدار</label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" value="{{ $user->lieu_delivrance_cin ?? '' }}" readonly>
                </div>
            </div>
            @endif



            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> العنوان الشخصي </label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="adresse" value="{{ old('adresse', Auth::user()->adresse ?? '') }}" readonly>
                </div>
            </div>
            

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> المستوى التعليمي </label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="niveau_etude" value="{{ old('niveau_etude', Auth::user()->niveau_etude ?? '') }}" readonly>
                </div>

                <label class="col-sm-2 col-form-label">آخر شهادة متحصل عليها</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="dernier_diplome" value="{{ old('dernier_diplome', Auth::user()->dernier_diplome ?? '') }}" readonly>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> الاقدمية في تعاطي النشاط </label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="experience" value="{{ old('experience', Auth::user()->experience ?? '') }}" readonly>
                </div>
            </div>
        </div>

        <div class="form-section mt-4">
            <h4> خاصيات النشاط </h4>
            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="" class="col-sm-10 col-form-label">
                        <strong> المؤسسة الشبابية الخاصة</strong>
                    </label>
                </div>
            </div>

            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="nature_projet_id" class="col-sm-10 col-form-label">
                        <strong> الرجاء الاختبار </strong>
                    </label>
                </div>
        
                <div class="col-sm-4">
                    <select required class="form-control" id="type_espace_id" name="type_espace_id">
                        <option value="" disabled selected>اختر...</option>
                        @foreach($types_espace as $type)
                            <option value="{{ $type->id_type }}">
                                {{ $type->type_ar }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>


            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="" class="col-sm-10 col-form-label">
                        <u> مميزات الفضاء  </u>
                    </label>
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> عدد الغرف </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="nbr_chambre" name="nbr_chambre" min=1>
                </div>

                <label class="col-sm-2 col-form-label"> عدد القاعات </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="nbr_salles" name="nbr_salles" min=1>
                </div>
            </div>
            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="" class="col-sm-10 col-form-label">
                        <u>طاقة الاستعاب</u>
                    </label>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">  بالمبيت </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="capacite_accueil_hebergement" name="capacite_accueil_hebergement" min=1>
                </div>

                <label class="col-sm-2 col-form-label">  تحت الخيام </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="capacite_accueil_sous_tente" name="capacite_accueil_sous_tente" min=1>
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">  بفضاءات النتشيط </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="capacite_accueil_espace_animation" name="capacite_accueil_espace_animation" min=1>
                </div>
            </div>

            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="nature_projet_id" class="col-sm-10 col-form-label">
                        <u> الخدمات التي تؤمنها المؤسسة  </u>
                    </label>
                </div>
            </div>
            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="heberg_rest" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="heberg_rest" name="heberg_rest" value="1">
                <label class="col-sm-6 col-form-label" for="heberg_rest">
                 الإقامة والتغذية
                </label>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="heberg_stage_activ" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="heberg_stage_activ" name="heberg_stage_activ" value="1">
                <label class="col-sm-6 col-form-label" for="heberg_stage_activ">
                إيواء التربصات والأنشطة التكوينية
                </label>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="camping" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="camping" name="camping" value="1">
                <label class="col-sm-6 col-form-label" for="camping">
                التخييم
                </label>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="activ_educative" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="activ_educative" name="activ_educative" value="1">
                <label class="col-sm-6 col-form-label" for="activ_educative">
                التنشيط التربوي والإجتماعي والثقافي
                </label>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="voyage" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="voyage" name="voyage" value="1">
                <label class="col-sm-6 col-form-label" for="voyage">
                الرحلات الداخلية والخارجية
                </label>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="evenement" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="evenement" name="evenement" value="1">
                <label class="col-sm-6 col-form-label" for="evenement">
                 التظاهرات الثقافية والحفلات
                </label>
            </div>

             <div class="form-check d-flex align-items-center">
                <input type="hidden" name="autre" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="autre" name="autre" value="1">
                <label class="col-sm-6 col-form-label" for="autre">
                 غير ذلك
                </label>
            </div>

            <div class="form-group row mb-3 align-items-center">
                <label class="col-sm-2 col-form-label">الاسم التجاري للمشروع</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="nom_projet" placeholder="الاسم التجاري للمشروع " maxlength="50">
                </div>
                <label class="col-sm-2 col-form-label" for="nature_projet_id">طبيعة المشروع</label>
                <div class="col-sm-4">
                    <select required class="form-control" id="nature_projet_id" name="nature_projet_id">
                        <option value="" disabled selected>اختر...</option>
                        @foreach($nature_projet as $nature)
                            <option value="{{ $nature->id_nature_p }}">
                                {{ $nature->nature_ar }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">  عدد مواطن الشغل </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="nbr_emplois" name="nbr_emplois" min=1>
                </div>
            </div>
            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="" class="col-sm-10 col-form-label">
                        <u>  مدير المؤسسة  </u>
                    </label>
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">الاسم و اللقب</label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="nom_prenom_d" placeholder="الاسم و اللقب   " maxlength="50">
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">رقم بطاقة التعريف الوطنية  </label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="num_cin" maxlength="8">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">تاريخ إصدار البطاقة</label>
                <div class="col-sm-4">
                    <input type="date" class="form-control" id="date_delivrance" name="date_delivrance" placeholder="تاريخ إصدار البطاقة">
                </div>

                <label class="col-sm-2 col-form-label">مكان الإصدار</label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" id="lieu_delivrance" name="lieu_delivrance" placeholder="مكان الإصدار">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> المستوى التعليمي </label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="niveau_etude" placeholder=" المستوى التعليمي ">
                </div>

                <label class="col-sm-2 col-form-label">آخر شهادة متحصل عليها</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="dernier_diplome_obtenu" placeholder="آخر شهادة متحصل عليها">
                </div>
            </div>
        </div>

        <h4>جدول الاستثمار و التمويل</h4>
        <div class="form-group row">
            <table id="investissement-table" class="custom-table">
                <thead>
                    <tr>
                        <th>الإستثمار</th>
                        <th>  مبلغ الإستثمار </th>
                        <th> التمويل</th>
                        <th>مبلغ التمويل</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody id="investissement-body">
                    <tr>
                        <td data-label="الإستثمار">
                            <select class="form-control" name="investissements[0][secteur_invest_id]" id="secteur_invest_id_0">
                                <option value="" disabled selected>اختر...</option>
                                @foreach($secteurs as $secteur)
                                    <option value="{{ $secteur->id_secteur }}">{{ $secteur->secteur_ar }}</option>
                                @endforeach
                            </select>
                        </td>
                        <td data-label="مبلغ الإستثمار">
                            <input type="number" name="investissements[0][montant_inv]" class="form-control" min=1>
                        </td>
                        <td data-label="مصادر التمويل">
                            <select class="form-control" name="investissements[0][id_source_financement]" id="id_source_financement">
                                <option value="" disabled selected>اختر...</option>
                                @foreach($source_fin as $source)
                                    <option value="{{ $source->id_source }}">{{ $source->source_ar }}</option>
                                @endforeach
                            </select>
                        </td>
                        <td data-label="مبلغ التمويل">
                            <input type="number" name="investissements[0][montant_fin]" class="form-control" min=1>
                        </td>
                        <td class="action-buttons">
                            <button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)">حذف</button>
                        </td>
                    </tr>
                </tbody>
            </table>
            <button type="button" class="btn btn-primary mt-2" onclick="addInvestissementRow()" style="background-color: #28a745; border-color: #28a745;">
                إضافة صف
            </button>
        </div>

        <div class="mt-3">
            <h4>تصريح على الشرف</h4>
            <span>
                إني الممضي أسفله أشهد بصحة البيانات التي تضمنتها هذه الإستمارة كما أصرح أني لم أتعرض إلى أي عقاب جزائي أو إداري من شأنه أن يحجر على إدارة و تسيير مؤسسة أو الإستثمار في الأنشطة المنصوص عليها.
            </span>
        </div>

        <div class="remarques-block mt-3 p-3" style="border: 2px solid #000; border-radius: 5px;">
            <h4> ملاحظات خاصة بالمندوبية الجهوية : </h4>
            <textarea class="form-control mt-2" name="remarques" rows="6" placeholder="اكتب ملاحظاتك هنا..."></textarea>
        </div>

        <div class="form-group row text-center" style="padding-top:50px;">
            <div class="col-sm-4 mx-auto">
                <button type="submit" class="btn btn-success font-weight-medium" style="width:100px;margin-right:250px;">إرسال</button>
            </div>
            <div class="col-sm-4 mx-auto">
                <a href="{{ route('jeune_enfant.index') }}" class="btn btn-primary" style="width:100px;margin-left:250px;">
                    <i class="bi bi-arrow-left"></i> رجوع
                </a>
            </div>
        </div>
    </form>
</div>
</div>


<script>
    document.addEventListener("DOMContentLoaded", function() {
    function toggleTextarea(checkboxId, textareaGroupId) {
        const checkbox = document.getElementById(checkboxId);
        const textareaGroup = document.getElementById(textareaGroupId);
        if (!checkbox || !textareaGroup) return;
            textareaGroup.style.display = checkbox.checked ? "block" : "none";
            checkbox.addEventListener("change", function() {
                textareaGroup.style.display = this.checked ? "block" : "none";
            });
        }
        toggleTextarea("espace_spectacle", "caracteristique_group");
        toggleTextarea("espace_sportif", "caracteristique_sportif_group");
        toggleTextarea("espace_activite_service", "caracteristique_activite_serv_group");
        toggleTextarea("espace_activite_culturelle", "caracteristique_activite_cult_group");

    });
</script>

<script>
    let investIndex = 1; 
    function addInvestissementRow() {
        let tableBody = document.getElementById('investissement-body');

        let newRow = `
            <tr>
                <td data-label="الإستثمار">
                    <select class="form-control" name="investissements[${investIndex}][secteur_invest_id]" id="secteur_invest_id_${investIndex}">
                        <option value="" disabled selected>اختر...</option>
                        @foreach($secteurs as $secteur)
                            <option value="{{ $secteur->id_secteur }}">{{ $secteur->secteur_ar }}</option>
                        @endforeach
                    </select>
                </td>
                <td data-label="الإستثمارالمبلغ ">
                    <input type="number" name="investissements[${investIndex}][montant_inv]" class="form-control" min=1>
                </td>
                <td data-label="مصادر التمويل">
                    <select class="form-control" name="investissements[${investIndex}][id_source_financement]" id="id_source_financement_${investIndex}">
                        <option value="" disabled selected>اختر...</option>
                        @foreach($source_fin as $source)
                            <option value="{{ $source->id_source }}">{{ $source->source_ar }}</option>
                        @endforeach
                    </select>
                </td>
                <td data-label="مبلغ التمويل">
                    <input type="number" name="investissements[${investIndex}][montant_fin]" class="form-control" min=1>
                </td>
                <td class="action-buttons">
                    <button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)">حذف</button>
                </td>
            </tr>
        `;

        tableBody.insertAdjacentHTML('beforeend', newRow);
        investIndex++;
    }

    function removeRow(button) {
        let row = button.closest('tr');
        row.remove();
    }
</script>

@else
    <script>
        window.location.href = "{{ route('login') }}";
    </script>
@endif
